﻿//////////////////////////////////////////////
// DefaultMemorySpaceAllocator.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkMemory
#include "MemorySpaceAllocator.h"

/// Class ------------------------------------

namespace nkMemory
{
	template <typename T>
	class DefaultMemorySpaceAllocator : public MemorySpaceAllocator<T>
	{
		public :

			// Implementation
			virtual UniquePtr<T> allocate (unsigned long long size) override
			{
				return makeUnique<T>(size) ;
			}
	} ;
}